/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemBalloon
extends Item {
    private final EnumColor color;

    public ItemBalloon(EnumColor color) {
        super(ItemDeferredRegister.getMekBaseProperties());
        this.color = color;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior(this.color));
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            boolean rightHand = player.m_5737_() == HumanoidArm.RIGHT == (hand == InteractionHand.MAIN_HAND);
            Pos3D pos = new Pos3D(rightHand ? -0.4 : 0.4, 0.0, 0.3).yRot(player.f_20883_).translate((Vec3)new Pos3D((Entity)player));
            EntityBalloon balloon = EntityBalloon.create(world, pos.f_82479_ - 0.5, pos.f_82480_ - 1.25, pos.f_82481_ - 0.5, this.color);
            if (balloon == null) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            world.m_7967_((Entity)balloon);
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemBalloon) {
            ItemBalloon balloon = (ItemBalloon)item;
            return TextComponentUtil.build((Object[])new Object[]{balloon.getColor(), super.m_7626_(stack)});
        }
        return super.m_7626_(stack);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        if (player.m_6144_()) {
            BlockPos pos = context.m_8083_();
            AABB bound = new AABB(pos, pos.m_142082_(1, 3, 1));
            List balloonsNear = player.f_19853_.m_45976_(EntityBalloon.class, bound);
            if (!balloonsNear.isEmpty()) {
                return InteractionResult.FAIL;
            }
            Level world = context.m_43725_();
            if (WorldUtils.isValidReplaceableBlock((BlockGetter)world, (BlockPos)pos)) {
                pos = pos.m_7495_();
            }
            if (!Block.m_49863_((LevelReader)world, (BlockPos)pos, (Direction)Direction.UP)) {
                return InteractionResult.FAIL;
            }
            if (WorldUtils.isValidReplaceableBlock((BlockGetter)world, (BlockPos)pos.m_7494_()) && WorldUtils.isValidReplaceableBlock((BlockGetter)world, (BlockPos)pos.m_6630_(2))) {
                world.m_7471_(pos.m_7494_(), false);
                world.m_7471_(pos.m_6630_(2), false);
                if (!world.f_46443_) {
                    EntityBalloon balloon = EntityBalloon.create(world, pos, this.color);
                    if (balloon == null) {
                        return InteractionResult.FAIL;
                    }
                    world.m_7967_((Entity)balloon);
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        if (player.m_6144_()) {
            if (!player.f_19853_.f_46443_) {
                AABB bound = new AABB(entity.m_20185_() - 0.2, entity.m_20186_() - 0.5, entity.m_20189_() - 0.2, entity.m_20185_() + 0.2, entity.m_20186_() + (double)entity.m_6972_((Pose)entity.m_20089_()).f_20378_ + 4.0, entity.m_20189_() + 0.2);
                List balloonsNear = player.f_19853_.m_45976_(EntityBalloon.class, bound);
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    return InteractionResult.SUCCESS;
                }
                EntityBalloon balloon = EntityBalloon.create(entity, this.color);
                if (balloon == null) {
                    return InteractionResult.FAIL;
                }
                player.f_19853_.m_7967_((Entity)balloon);
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static class DispenserBehavior
    extends DefaultDispenseItemBehavior {
        private final EnumColor color;

        public DispenserBehavior(EnumColor color) {
            this.color = color;
        }

        @Nonnull
        public ItemStack m_7498_(BlockSource source, @Nonnull ItemStack stack) {
            Direction side = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos sourcePos = source.m_7961_();
            BlockPos offsetPos = sourcePos.m_142300_(side);
            List entities = source.m_7727_().m_45976_(LivingEntity.class, new AABB(offsetPos, offsetPos.m_142082_(1, 1, 1)));
            boolean latched = false;
            for (LivingEntity entity : entities) {
                AABB bound = new AABB(entity.m_20185_() - 0.2, entity.m_20186_() - 0.5, entity.m_20189_() - 0.2, entity.m_20185_() + 0.2, entity.m_20186_() + (double)entity.m_6972_((Pose)entity.m_20089_()).f_20378_ + 4.0, entity.m_20189_() + 0.2);
                List balloonsNear = source.m_7727_().m_45976_(EntityBalloon.class, bound);
                boolean hasBalloon = false;
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    hasBalloon = true;
                    break;
                }
                if (hasBalloon) continue;
                EntityBalloon balloon = EntityBalloon.create(entity, this.color);
                if (balloon != null) {
                    source.m_7727_().m_7967_((Entity)balloon);
                }
                latched = true;
            }
            if (!latched) {
                EntityBalloon balloon;
                Vec3 pos = Vec3.m_82528_((Vec3i)sourcePos).m_82520_(0.0, -0.5, 0.0);
                switch (side) {
                    case DOWN: {
                        pos = pos.m_82520_(0.0, -3.5, 0.0);
                        break;
                    }
                    case NORTH: {
                        pos = pos.m_82520_(0.0, -1.0, -0.5);
                        break;
                    }
                    case SOUTH: {
                        pos = pos.m_82520_(0.0, -1.0, 0.5);
                        break;
                    }
                    case WEST: {
                        pos = pos.m_82520_(-0.5, -1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        pos = pos.m_82520_(0.5, -1.0, 0.0);
                    }
                }
                if (!source.m_7727_().f_46443_ && (balloon = EntityBalloon.create((Level)source.m_7727_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, this.color)) != null) {
                    source.m_7727_().m_7967_((Entity)balloon);
                }
            }
            stack.m_41774_(1);
            return stack;
        }
    }
}

